%Road main
% Spousti vypocet generovani nerovnosti vozovky
%-------------------------------------------------------------------------
% Witten By Tomas Mauder, VUT v Brne, 2014.
%-------------------------------------------------------------------------
close all
clear

% Nacte parametry simulace
Road

% graphs = 1 zobrazi grafy PSD a povrchu vozovky
graphs = 1;

% pocet opakovanych volani
repeat  = 1;

for i = 1:repeat;
% generovani PSD
[A omega phi psi] = Road_PSD(road,graphs);

% generovani nahodne cesty
y(i,:) = Road_creation_1D(road,A, omega, psi,graphs);

end

if repeat == 1
    z = y;
else
    z = sum(y)/repeat;
end

% test normality nahodne cesty
Road_normality_test(z,graphs)

% ukladani dat
z = [road.s' z'];
save('road_output.dat','z','-tabs','-ascii','-double')  
save('road_output.mat','z','-tabs','-double')  
